//
//  This file is part of the NineAnimator project.
//
//  Copyright © 2018-2020 Marcus Zhou. All rights reserved.
//
//  NineAnimator is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  NineAnimator is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with NineAnimator.  If not, see <http://www.gnu.org/licenses/>.
//

import NineAnimatorCommon
import NineAnimatorNativeParsers
import NineAnimatorNativeSources
import UIKit

class QuickActionsTableViewCell: UITableViewCell, UICollectionViewDataSource, UICollectionViewDelegate {
    @IBOutlet private weak var collectionView: UICollectionView!
    private var quickActions = [DiscoverySceneViewController.QuickAction]()
    private var quickActionCompletionHandler: ((DiscoverySceneViewController.QuickAction) -> Void)?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        // Set collection view delegate and datasource
        collectionView.delegate = self
        collectionView.dataSource = self
    }
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        guard section == 0 else { return 0 }
        return quickActions.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let action = quickActions[indexPath.item]
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "action", for: indexPath) as! Cell
        
        if let completionHandler = self.quickActionCompletionHandler {
            cell.setPresenting(action, completionHandler: completionHandler)
        }
        
        return cell
    }
    
    func updateQuickActionsList(_ list: [DiscoverySceneViewController.QuickAction], completionHandler: @escaping (DiscoverySceneViewController.QuickAction) -> Void) {
        self.quickActions = list
        self.quickActionCompletionHandler = completionHandler
        self.collectionView.reloadData()
    }
    
    func collectionView(_ collectionView: UICollectionView, willDisplay cell: UICollectionViewCell, forItemAt indexPath: IndexPath) {
        cell.makeThemable()
    }
}
